package ${project_rootPackage}.core;

import ${project_rootPackage}.${test_container_prefix}TestContainer;
import io.bpmstudio.cuba.core.EntityManager;
import io.bpmstudio.cuba.core.Persistence;
import io.bpmstudio.cuba.core.Transaction;
import io.bpmstudio.cuba.core.TypedQuery;
import io.bpmstudio.cuba.core.global.AppBeans;
import io.bpmstudio.cuba.core.global.DataManager;
import io.bpmstudio.cuba.core.global.Metadata;
import io.bpmstudio.cuba.security.entity.User;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import java.util.List;

import static org.junit.Assert.assertEquals;

public class SampleIntegrationTest {

    @ClassRule
    public static ${test_container_prefix}TestContainer cont = ${test_container_prefix}TestContainer.Common.INSTANCE;

    private Metadata metadata;
    private Persistence persistence;
    private DataManager dataManager;

    @Before
    public void setUp() throws Exception {
        metadata = cont.metadata();
        persistence = cont.persistence();
        dataManager = AppBeans.get(DataManager.class);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLoadUser() {
        try (Transaction tx = persistence.createTransaction()) {
            EntityManager em = persistence.getEntityManager();
            TypedQuery<User> query = em.createQuery(
                    "select u from sec\$User u where u.login = :userLogin", User.class);
            query.setParameter("userLogin", "admin");
            List<User> users = query.getResultList();
            tx.commit();
            assertEquals(1, users.size());
        }
    }
}